<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Calls</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Calls</h1>
				<xsl:call-template name="calls"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="calls">
	<table>
		<tr>
			<th>id</th>
			<th>number</th>
			<th>duration</th>
			<th>type</th>
			<th>isNew</th>
			<th>name</th>
			<th>numberType</th>
			<th>numberLabel</th>
			<th>date</th>
		</tr>
		
		<xsl:for-each select="call">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@number"/></td>
				<td><xsl:value-of select="@duration"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@isNew"/></td>
				<td>
					<xsl:if test="not( @name = 'name not provided' )">
						<xsl:value-of select="@name"/>
					</xsl:if>
				</td>
				<td><xsl:value-of select="@numberType"/></td>
				<td><xsl:value-of select="@numberLabel"/></td>
				<td><xsl:value-of select="@date"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

